# User visible changes in `mruby3.3` from `mruby3.2`

"**_NOTE_**:" are changes to be aware of.

# The language

- aliases work properly with `super` ([2ad3f0e](https://github.com/mruby/mruby/commit/2ad3f0e))
- `callee` method work differently with aliases in mruby ([f2dc76e](https://github.com/mruby/mruby/commit/f2dc76e))
- define `Kernel#respond_to_missing?` method ([347586e](https://github.com/mruby/mruby/commit/347586e))
- `_inspect` method (`inspect` with recursive check) is removed
  ([e2bbf75](https://github.com/mruby/mruby/commit/e2bbf75), [5cb0c74](https://github.com/mruby/mruby/commit/5cb0c74), [113565a](https://github.com/mruby/mruby/commit/113565a),
  [0713f2a](https://github.com/mruby/mruby/commit/0713f2a), [6ae6b63](https://github.com/mruby/mruby/commit/6ae6b63), [fc9fffc](https://github.com/mruby/mruby/commit/fc9fffc))
- `__printstr__` method is removed; use `print` instead
  ([acecee0](https://github.com/mruby/mruby/commit/acecee0), [192e6e3](https://github.com/mruby/mruby/commit/192e6e3))
- New method `String#bytesplice` ([5274647](https://github.com/mruby/mruby/commit/5274647), [a2e2e83](https://github.com/mruby/mruby/commit/a2e2e83))
- Allow `return` in blocks to cross C boundaries ([#6125](https://github.com/mruby/mruby/pull/6125))

# Configuration

- mruby can be built using Docker now. Try `docker-compose build` for example. ([#5961](https://github.com/mruby/mruby/pull/5961))
- New Platform: DJGPP (MS-DOS) ([#6022](https://github.com/mruby/mruby/pull/6022))
- New Platform: Nintendo Wii ([#6086](https://github.com/mruby/mruby/pull/6086))
- Improved Platform: Android ([#6013](https://github.com/mruby/mruby/pull/6013))
- Improved Platform: Dreamcast ([#6130](https://github.com/mruby/mruby/pull/6130))
- Allow tests to be disabled for specific gems; warn about disabled tests ([#6012](https://github.com/mruby/mruby/pull/6012))
- Replace `MRB_NO_DIRECT_THREADING` with `MRB_USE_VM_SWITCH_DISPATCH` ([#5902](https://github.com/mruby/mruby/pull/5902))

# mruby memory API

- `mrb_default_allocf` can be overridden by the application ([34c5d96](https://github.com/mruby/mruby/commit/34c5d96))
- `mrb_open_allocf` will be deprecated ([cfee5c2](https://github.com/mruby/mruby/commit/cfee5c2))

# Changes in C API

- add new error handling API functions ([8c8bbd9](https://github.com/mruby/mruby/commit/8c8bbd9))
- Add `mrb_vm_ci_env_clear()` function with `MRB_API` ([#5945](https://github.com/mruby/mruby/pull/5945))
- a new function `mrb_check_frozen_value()` ([ccdf75c](https://github.com/mruby/mruby/commit/ccdf75c))
- avoid formatting in `mrb_bug()` ([82a48bd](https://github.com/mruby/mruby/commit/82a48bd)) <br>
  **_NOTE_**: If you are using it, you must give a simple string or replace it with a call to `mrb_raise()` series.
- stop using `mrbc_` prefix for compiler context ([c5e3cbe](https://github.com/mruby/mruby/commit/c5e3cbe)) <br>
  The same names are provided as before, but we recommend replacing them.
- Allow `Class#allocate` to be prohibited
  ([#5979](https://github.com/mruby/mruby/pull/5979), [#6122](https://github.com/mruby/mruby/pull/6122), [#6123](https://github.com/mruby/mruby/pull/6123)) <br>
  To disable `#allocate`, use `MRB_UNDEF_ALLOCATOR()`.
  This is also automatically applied when the subclass is created, but to explicitly allow it, use `MRB_DEFINE_ALLOCATOR()`.

# Changes in mrbgems

- **default.gembox**: Add mruby debugger mrdb (`mruby-bin-debugger`) ([#5966](https://github.com/mruby/mruby/pull/5966))
- **mruby-bin-config**: new options `--cxx`, `--cxxflags`, `--as`, `--asflags`, `--objc`, `--objcflags` ([#6054](https://github.com/mruby/mruby/pull/6054))
- **mruby-binding**: renamed from `mruby-binding-core` of mruby3.2 ([11af5db](https://github.com/mruby/mruby/commit/11af5db)) <br>
  **_NOTE_**: If using `mruby-binding-core` of mruby 3.2, replace it with `mruby-binding`.
- **mruby-binding**: implemented `Binding#initialize_copy` method ([#5517](https://github.com/mruby/mruby/pull/5517))
- **mruby-binding**: `Kernel#binding` responds only to calls from Ruby ([#5981](https://github.com/mruby/mruby/pull/5981))
- **mruby-compar-ext**: Comparable#clamp to accept nil as arguments ([836bebc](https://github.com/mruby/mruby/commit/836bebc))
- **mruby-compiler**: add print name for identifier tokens ([d7b2e3a](https://github.com/mruby/mruby/commit/d7b2e3a))
- **mruby-data**: allow empty Data ([927a9df](https://github.com/mruby/mruby/commit/927a9df))
- **mruby-enumerator**: remove internal attribute methods `obj`, `args`, `kwd`, `meth`, `fib`. ([735fa24](https://github.com/mruby/mruby/commit/735fa24))
- **mruby-enumerator**: add Enumerator#size ([861f8bd](https://github.com/mruby/mruby/commit/861f8bd))
- **mruby-eval**: merged `mruby-binding` of mruby3.2 ([501b22a](https://github.com/mruby/mruby/commit/501b22a), [#5989](https://github.com/mruby/mruby/pull/5989)) <br>
  **_NOTE_**: If using `mruby-binding` of mruby 3.2, replace it with `mruby-eval`.
- **mruby-fiber**: Add a new `mrb_fiber_new()` with `MRB_API` ([#6097](https://github.com/mruby/mruby/pull/6097))
- **mruby-fiber**: Allows calling `Fiber#resume` from C ([#6106](https://github.com/mruby/mruby/pull/6106))
- **mruby-fiber**: `Fiber#to_s` format changed ([#6105](https://github.com/mruby/mruby/pull/6105))
- **mruby-io**: add File#atime and File#ctime ([321cfe9](https://github.com/mruby/mruby/commit/321cfe9))
- **mruby-io**: Add "x" mode option for `IO.open` ([#6081](https://github.com/mruby/mruby/pull/6081))
- **mruby-io**: File.new should not take blocks ([53de964](https://github.com/mruby/mruby/commit/53de964))
- **mruby-method**: `Method#to_s` format changed ([f5bc82f](https://github.com/mruby/mruby/commit/f5bc82f), [02f189c](https://github.com/mruby/mruby/commit/02f189c))
- **mruby-numeric-ext**: `int.pow(n,m)` to take bigint as exponential ([d482eab](https://github.com/mruby/mruby/commit/d482eab))
- **mruby-pack**: support new directives `j`, `J`, `b`, `B`, `#`
  ([2a1e3a5](https://github.com/mruby/mruby/commit/2a1e3a5), [e7021f1](https://github.com/mruby/mruby/commit/e7021f1), [e17f325](https://github.com/mruby/mruby/commit/e17f325))
- **mruby-range-ext**: new method `Range#overlap?` ([384d0e2](https://github.com/mruby/mruby/commit/384d0e2))
- **mruby-string-ext**: Add `String#valid_encoding?` method ([eabe2d9](https://github.com/mruby/mruby/commit/eabe2d9))
- **mruby-struct**: allow empty Struct when a name is not given ([c212ede](https://github.com/mruby/mruby/commit/c212ede))
- **mruby-time**: should allow year before 1900 ([e5de08b](https://github.com/mruby/mruby/commit/e5de08b))
- **mruby-time**: support bigint to time_t if necessary ([7096d27](https://github.com/mruby/mruby/commit/7096d27))
- **mruby-time**: need to handle negative time_t ([b064d7e](https://github.com/mruby/mruby/commit/b064d7e))

# Changes in build system

- Extended `rake install` task ([#5928](https://github.com/mruby/mruby/pull/5928)) <br>
  **_NOTE_**: Due to this impact, executable files in the `mruby/bin/` directory by default are now symbolic links (batch files on Windows).
  If previously relied on those executables, should be replaced with direct references to the entity created under the build directory (e.g. `mruby/build/host/bin/`).
- Encode and decode escape characters for presym ([#6011](https://github.com/mruby/mruby/pull/6011))
- Rakefile: remove default build target directories in `deep_clean` ([#6032](https://github.com/mruby/mruby/pull/6032), [1e38569](https://github.com/mruby/mruby/commit/1e38569))

# Other breaking changes

- `mrb_f_raise()` is now an internal function
  ([#5923](https://github.com/mruby/mruby/pull/5923), [#6070](https://github.com/mruby/mruby/pull/6070))
- `mrb_make_exception()` is now an internal function with different parameters
  ([431f83e](https://github.com/mruby/mruby/commit/431f83e), [78137f3](https://github.com/mruby/mruby/commit/78137f3))
- The `File#path` method no longer uses the `#to_path` method for implicit conversion
  ([d86c4a7](https://github.com/mruby/mruby/commit/d86c4a7))
- stop mrb isolation for each test file ([a20fbe5](https://github.com/mruby/mruby/commit/a20fbe5))
- RBreak remembers the CI location ([#6103](https://github.com/mruby/mruby/pull/6103))

# Bugs Fixed

- [#5724](https://github.com/mruby/mruby/issues/5724) Rational#\*\* is missing
- [#5725](https://github.com/mruby/mruby/issues/5725) weird const_missing exceptions in mrblib code
- [#5789](https://github.com/mruby/mruby/issues/5789) No memory release of backtrace information due to stack error
- [#5932](https://github.com/mruby/mruby/issues/5932) How to create a block using the C API? mrb_yield keeps crashing!
- [#5943](https://github.com/mruby/mruby/issues/5943) TCPSocket#write is failed
- [#5944](https://github.com/mruby/mruby/issues/5944) Behavior of calling method with a hash variable
- [#5946](https://github.com/mruby/mruby/pull/5946) Don't switch constant search path from modules to Object
- [#5949](https://github.com/mruby/mruby/issues/5949) Caller appears to report wrong line when block passed and brackets omitted
- [0906cd7](https://github.com/mruby/mruby/commit/0906cd7) numeric.c: fix rounding function issues with big numbers
- [#5974](https://github.com/mruby/mruby/issues/5974) Invalid escape sequences in gem_init.c on windows
- [#5975](https://github.com/mruby/mruby/issues/5975) Equals comparison fails on extreme ends of 64-bit integers
- [#5985](https://github.com/mruby/mruby/issues/5985) Sign extension with OP_LOADI32 in get_int_operand()
- [#5986](https://github.com/mruby/mruby/issues/5986) Fix bugs in String#bytesplice
- [#5987](https://github.com/mruby/mruby/issues/5987) ~(-1 << 64) is incorrect
- [#5991](https://github.com/mruby/mruby/issues/5991) 'gets' method not working in mruby-3.2.0
- [#5994](https://github.com/mruby/mruby/pull/5994) fix typo in mrbgems/mruby-io/src/io.c
- [#5995](https://github.com/mruby/mruby/issues/5995) One seemingly unnecessary parameter is passed in the block parameters
- [#6008](https://github.com/mruby/mruby/pull/6008) Make "bintest" independent of directory
- [b47c8b7](https://github.com/mruby/mruby/commit/b47c8b7) gc.c (clear_all_old): fix a generational GC bug
- [#6029](https://github.com/mruby/mruby/issues/6029) mruby build fails under mrbgems directory
- [a264965](https://github.com/mruby/mruby/commit/a264965) mruby-os-memsize/memsize.c: fix irep size calculation
- [3310e10](https://github.com/mruby/mruby/commit/3310e10) mruby-test/mrbgem.rake: fix mrb_state handling bug
- [#6041](https://github.com/mruby/mruby/issues/6041) GC Performance may have degraded
- [#6044](https://github.com/mruby/mruby/issues/6044) Generated presym/table.h contains invalid characters
- [#6051](https://github.com/mruby/mruby/issues/6051) Null pointer dereference in mrb_addrinfo_unix_path
- [#6052](https://github.com/mruby/mruby/issues/6052) Null pointer dereference while handling the Proc class
- [#6055](https://github.com/mruby/mruby/pull/6055) Fix libmruby name for VisualC++
- [#6060](https://github.com/mruby/mruby/issues/6060) SEGFAULT Issue Related to Fiber Usage in ngx_mruby Development
- [#6061](https://github.com/mruby/mruby/issues/6061) Performance issue in String#codepoints
- [#6064](https://github.com/mruby/mruby/issues/6064) MRUBY_PACKAGE_DIR does not always have a value.
- [#6065](https://github.com/mruby/mruby/issues/6065) Null pointer dereference while handling the Proc class
- [#6066](https://github.com/mruby/mruby/issues/6066) Null pointer dereference involving Struct.new()
- [#6067](https://github.com/mruby/mruby/issues/6067) Null pointer dereference in mrb_string_value_cstr
- [#6068](https://github.com/mruby/mruby/issues/6068) Stack overflow in mrb_vm_exec
- [#6076](https://github.com/mruby/mruby/pull/6076) Fixed unwinding block that could point to invalid PC
- [#6084](https://github.com/mruby/mruby/issues/6084) Incorrect symbolic sinks in binary built on Linux
- [#6087](https://github.com/mruby/mruby/issues/6087) 'Remote branch HEAD not found in upstream origin' error on build
- [#6089](https://github.com/mruby/mruby/issues/6089) binding.eval() handles def expressions differently from CRuby
- [#6098](https://github.com/mruby/mruby/issues/6098) Fails to call superclass of wrapped method
- [#6099](https://github.com/mruby/mruby/issues/6099) `ensure` section is not executed if the function exits via a return in a proc
- [#6108](https://github.com/mruby/mruby/issues/6108) VM crashes with break
- [#6118](https://github.com/mruby/mruby/pull/6118) Fixed IO#read with buf
- [#6120](https://github.com/mruby/mruby/pull/6120) Set EBADF if check_file_descriptor() fails
- [#6126](https://github.com/mruby/mruby/pull/6126) Fixed return value of `OP_RETURN_BLK` called directly under C function
- [#6134](https://github.com/mruby/mruby/issues/6134) String#unpack1 returns an array instead of a single string
- [#6136](https://github.com/mruby/mruby/pull/6136) Fixed when combined `mrb_fiber_resume()` and `Fiber#transfer`

# Pull Requests (User Visible Ones)

- [#5517](https://github.com/mruby/mruby/pull/5517) Fixed local variables not separated between copied binding objects
- [#5902](https://github.com/mruby/mruby/pull/5902) Replace `MRB_NO_DIRECT_THREADING` with `MRB_USE_VM_SWITCH_DISPATCH`
- [#5923](https://github.com/mruby/mruby/pull/5923) Demotion `mrb_f_raise()` from `MRB_API`
- [#5928](https://github.com/mruby/mruby/pull/5928) Improved `rake install`
- [#5945](https://github.com/mruby/mruby/pull/5945) Avoid exposure for `REnv` objects
- [#5946](https://github.com/mruby/mruby/pull/5946) Don't switch constant search path from modules to Object
- [#5966](https://github.com/mruby/mruby/pull/5966) Update default.gembox add mruby debugger mrdb
- [#5979](https://github.com/mruby/mruby/pull/5979) Allow Class#allocate to be prohibited
- [#5981](https://github.com/mruby/mruby/pull/5981) `Kernel#binding` responds only to calls from Ruby
- [#5989](https://github.com/mruby/mruby/pull/5989) Integrate mruby-binding-eval into mruby-eval
- [#5961](https://github.com/mruby/mruby/pull/5961) Add Docker to build and run all mruby tests. Run pre-commit and generate YARD docs with Docker
- [#5994](https://github.com/mruby/mruby/pull/5994) fix typo in mrbgems/mruby-io/src/io.c
- [#6008](https://github.com/mruby/mruby/pull/6008) Make "bintest" independent of directory
- [#6009](https://github.com/mruby/mruby/pull/6009) Avoid adding <MRUBY_ROOT>/bintest which does not exist
- [#6011](https://github.com/mruby/mruby/pull/6011) Encode and decode escape characters for presym
- [#6012](https://github.com/mruby/mruby/pull/6012) Allow tests to be disabled for specific gems; warn about disabled tests
- [#6013](https://github.com/mruby/mruby/pull/6013) Fix Android toolchain
- [#6022](https://github.com/mruby/mruby/pull/6022) Build configuration for MS-DOS and DJGPP
- [#6032](https://github.com/mruby/mruby/pull/6032) Rake: update task clean to remove bin and build folders
- [#6045](https://github.com/mruby/mruby/pull/6045) Fixes escape sequence bug and enhancements in Presym scanning
- [#6054](https://github.com/mruby/mruby/pull/6054) Extends `bin/mruby-config`
- [#6055](https://github.com/mruby/mruby/pull/6055) Fix libmruby name for VisualC++
- [#6070](https://github.com/mruby/mruby/pull/6070) Demotion mrb_f_raise() in kernel.c from MRB_API too
- [#6076](https://github.com/mruby/mruby/pull/6076) Fixed unwinding block that could point to invalid PC
- [#6081](https://github.com/mruby/mruby/pull/6081) Add "x" mode option for IO.open
- [#6086](https://github.com/mruby/mruby/pull/6086) Add build config for Nintendo Wii
- [#6097](https://github.com/mruby/mruby/pull/6097) Add a new mrb_fiber_new() with MRB_API
- [#6103](https://github.com/mruby/mruby/pull/6103) RBreak remembers the CI location
- [#6105](https://github.com/mruby/mruby/pull/6105) Implement `Fiber#to_s` method
- [#6106](https://github.com/mruby/mruby/pull/6106) Ease fiber limitations
- [#6118](https://github.com/mruby/mruby/pull/6118) Fixed IO#read with buf
- [#6120](https://github.com/mruby/mruby/pull/6120) Set EBADF if check_file_descriptor() fails
- [#6122](https://github.com/mruby/mruby/pull/6122) Prohibit `Class#allocate` in a different way
- [#6123](https://github.com/mruby/mruby/pull/6123) Inherit `MRB_FL_UNDEF_ALLOCATE` in subclasses
- [#6125](https://github.com/mruby/mruby/pull/6125) Allow `OP_RETURN_BLK` to cross C boundaries
- [#6126](https://github.com/mruby/mruby/pull/6126) Fixed return value of `OP_RETURN_BLK` called directly under C function
- [#6130](https://github.com/mruby/mruby/pull/6130) `dreamcast_shelf build config`: complete overhaul
- [#6136](https://github.com/mruby/mruby/pull/6136) Fixed when combined `mrb_fiber_resume()` and `Fiber#transfer`
